
#include    "string.h"
/*#include    "stdlib.h"*/
#include    "main.h"
#include		"lcm.h"
#include		"led.h"
#include		"button.h"
#include		"variable.h"
#include		"bc7701.h"
#include		"bleprocess.h"
#include		"service.h"

uc8	ver1_str[]= "BC7701 ";
uc8	ver2_str[]= "Dev Kit";
uc8	ver3_str[]= "Ver 1.0";
uc8	BLEPwronStateStr[]="BLE Pwr On :    ";
uc8   BLEConnectStateStr[] = "BLE Connet: No  ";
uc8	BLEKey1StateStr[] = "Host KEY 1: Up  ";
uc8	BLEKey2StateStr[] = "Host KEY 2: Up  ";
uc8	BLEKey3StateStr[] = "Host KEY 3: Up  ";
uc8	PassString[] = "OK  ";
uc8	FailString[] = "Fail";
uc8	YesString[] = "Yes";
uc8	NoString[] = "No ";
uc8	UpString[] = "Up";
uc8	DnString[] = "Dn";
uc8 CntString[] = "CNT=            ";

extern	BLE_OPERATE	BLEOperate;
extern 	u8	ReciveData[];

#define	BCIEVENT				((tBCI_PACKAGE *)ReciveData)

bit	SystemSleep;
bit	Timer2ms;
bit	ButtonChange;
bit	BLE_PwronState;
bit	BLE_ConnectState,BLE_ConnectDisplay;
bit	BLE_ReadCnntIntv;
bit	BLE_SleepMode;
bit	NotifyFFF1_Enable;
bit	BLE_WaitEventRsp;
bit	BLE_WakeUpDelay;
bit	LEDStatusUpdate;
bit	MCU_EnterSleep;

byte_t BLE_SendFlag;
#define	BLE_SendMessage		BLE_SendFlag.bits.b0
#define	BLE_SendCmdIdx			BLE_SendFlag.bits.b1
#define	BLE_SendCmdOpcode		BLE_SendFlag.bits.b2
#define	BLE_WakeUpSignal		BLE_SendFlag.bits.b3

u8		key_status;
KEY_MESSAGE	Hmessage,Dmessage;
u8		TimePeriod;
u16	ConnectIntervalTime;
u8		*BLE_CmdIndex;
u16	BLE_CmdOpcode;
u8		BLE_CmdFlag;
u8		BLE_WakeUpDlyTm;
u16	BLE_SleepDlyTm;
u8 NUM[8];

#define	_CHG_CONNECT_INTV_			1
/*------ Min Interval(ms)<10-40000> ------------------------------*/
#define 	_CNNT_INTV_MIN_VALUE_  		(30)
/*------ Max Interval(ms)<10-40000> ------------------------------*/
#define 	_CNNT_INTV_MAX_VALUE_  		(30)

#if	(_CHG_CONNECT_INTV_ == 1)
const tBCI_PACKAGE	BLE_SetConnectIntv =
{
	BCI_CMD_PKG,				//head type
	3+8,							//length
	0x00,							//Flag
	BCI_CONN_INTV1,			//opcode 
	{
		((u16)(_CNNT_INTV_MIN_VALUE_/1.25)) & 0xFF,		
		((u16)(_CNNT_INTV_MIN_VALUE_/1.25)) >> 8,
		((u16)(_CNNT_INTV_MAX_VALUE_/1.25)) & 0xFF,
		((u16)(_CNNT_INTV_MAX_VALUE_/1.25)) >> 8,
		0x00,0x00,(300 & 0xFF),( 300 >> 8)
	}
};
#endif

/* MCU sleep mode Enable/disable	*/
#define	_MCU_SLEEP_ENABLE_  		1
/* Enter deep sleep delay timer(ms)<10-5000>	*/
#define 	_SLEEP_DELAY_TIMER_  	(500/2)
/* Wake up Signal Width(byte)<1-8>	*/
#define 	_MASTER_WUW_VALUE_  		(1)
/* Wake up Signal delay time(ms)<0-20>	*/
#define 	_MASTER_WUT_VALUE_  		(4)

#if (_MCU_SLEEP_ENABLE_ == 1)
const tBCI_PACKAGE	BC7701_OperateSleep_WKUP=
{
	BCI_CMD_PKG,				//head type
	3+8,							//length
	0x00,							//Flag
	BCI_OPERATE_MODE,			//opcode 
	{ OP_DEEPSLEEP,0,0,0,1,_MASTER_WUT_VALUE_,_MASTER_WUW_VALUE_,0 } //parameter
};
#endif
/*---------------------------------------------------------------------------*/
/*   */
/*---------------------------------------------------------------------------*/
void main(void)
{  
	u8	x;
	  
   if((_pdf == TRUE) && (_to == TRUE)) goto WakeUpBegin;
	SystemClockConfigure();
	LCM_InterfaceConfigure();
	LCM_Initialize();
	LED_InterfaceConfigure();
	BTN_InterfaceConfigure();
	LCM_BCLogo();
	LCM_ConstString8(ver1_str,4,9,DSP_NORMAL);
	LCM_ConstString8(ver2_str,5,9,DSP_NORMAL);
	LCM_ConstString8(ver3_str,6,9,DSP_NORMAL);
	LED_AlwaysOn(LEDP);		
	for(x=0;x<50;x++) DelayXmSec(50*T1MS);	
	LCM_Clear();
	LCM_ConstString8(BLEPwronStateStr,0,0,DSP_NORMAL);
	LCM_ConstString8(BLEConnectStateStr,1,0,DSP_NORMAL);
	LCM_ConstString8(BLEKey1StateStr,2,0,DSP_NORMAL);
	LCM_ConstString8(BLEKey2StateStr,3,0,DSP_NORMAL);
	LCM_ConstString8(BLEKey3StateStr,4,0,DSP_NORMAL);
	SysTick2msConfigure();
	BLE_EnterPowerUp();
	
	_pdc2 = 0;
	
	SystemSleep = FALSE;
	Timer2ms = FALSE;	
   _emi = TRUE;
MainLoop:
	while(SystemSleep == FALSE)
	{
		GCC_CLRWDT();		
		if(Timer2ms)
		{
			Timer2ms = FALSE;
			ButtonChange = BTN_ScanStatus();
			LED_FlashProcess();
			BLE_TimerProcess();
			if(TimePeriod != 0) TimePeriod--;
			if(BLE_WakeUpDlyTm != 0) BLE_WakeUpDlyTm--;
			if(BLE_SleepDlyTm != 0) BLE_SleepDlyTm--;
		}
		/* BLE process */
		BLE_process();
				
		if(BLEOperate.State == _BLE_PWR_ON_SUCCESS_)
		{
			if(BLE_PwronState == FALSE)			/* first time power on */
			{
				LCM_ConstString8(PassString,0,12,DSP_NORMAL);
#if (_PWRON_FINISH_SLEEP_ == 1)
				BLE_SleepMode = TRUE;
#else
				BLE_SleepMode = FALSE;
#endif				
				BLE_SleepDlyTm = _SLEEP_DELAY_TIMER_;
				BLE_SendFlag.value = 0;
				BLE_WaitEventRsp = FALSE;
				BLE_PwronState = TRUE;
			}
			if(BLEOperate.F.B.EventValid)
			{
				if(ReciveData[0] == BCI_EVENT_PKG)
				{
					// command event response message
					if(BCIEVENT->opcode < GenericAccess)
					{
						switch(BCIEVENT->opcode)
						{
							case BCI_OPERATE_MODE:
								if((BCIEVENT->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
								{
									BLE_SleepMode = TRUE;
#if	(_MCU_SLEEP_ENABLE_ == 1)
									SystemSleep = TRUE;
#endif									
								}
								BLE_WaitEventRsp = FALSE;
								break;
							case BCI_STATUS:
								if(((tSTATUS *)(BCIEVENT->param))->b.Connect) BLE_ConnectState = TRUE;
								else BLE_ConnectState = FALSE;
								if(((tSTATUS *)(BCIEVENT->param))->b.PramUpdataPeer) BLE_ReadCnntIntv = TRUE;
								break;
							case BCI_CONN_INTV:
							case BCI_CONN_INTV1:
								if(((BCIEVENT->flag & EVTS_CODE_MASK) == EVTS_SUCCESS) &&
									(BCIEVENT->length > 3))
								{									
									ConnectIntervalTime = (BCIEVENT->param[1] << 8) + BCIEVENT->param[0];
									/* unit 1.25ms, 10/8=1.25 */
									ConnectIntervalTime *= 10;
									ConnectIntervalTime /= 8;
									NUM[0]=(u8)((ConnectIntervalTime/1000)+0x30);
									ConnectIntervalTime %=1000;
									NUM[1]=(u8)((ConnectIntervalTime/100)+0x30);
									ConnectIntervalTime %=100;
									NUM[2]=(u8)((ConnectIntervalTime/10)+0x30);
									NUM[3]=(u8)((ConnectIntervalTime%10)+0x30);											
									LCM_ConstString8(CntString,7,0,DSP_NORMAL);
									LCM_PutString8(NUM,7,4,DSP_NORMAL);								
								}
								BLE_WaitEventRsp = FALSE;								
								break;
							case BCI_TEST_CTRL:
								BLE_SleepMode = FALSE;
								BLE_WaitEventRsp = FALSE;
								break;								
						}
					}
					else	// profile message or event response
					{
						if((BCIEVENT->opcode == NotifyFFF1)	&& (BCIEVENT->length == 3))	BLE_WaitEventRsp = FALSE;
						switch(BCIEVENT->flag & BCI_ServiceCmdMask)
						{
							case BCI_ServiceMessage:
								if((BCIEVENT->opcode == WithoutResponseFFF2) && ((BCIEVENT->flag & EVTS_CODE_MASK) == EVTS_SUCCESS))
								{									
									if((BCIEVENT->length == 4+3) && (BCIEVENT->param[0] == 0xB0) )
									{
										Hmessage.type = BCIEVENT->param[0];
										Hmessage.key = BCIEVENT->param[1];
										Hmessage.serial = BCIEVENT->param[2];
										Hmessage.checksum = BCIEVENT->param[3];
										LEDStatusUpdate = TRUE;																						
									}
								}
								break;
							case BCI_ServiceSupported:
								break;
							case BCI_ServiceProperties:								
								if((BCIEVENT->opcode == NotifyFFF1) && (BCIEVENT->length == 5))
								{
									if(*((u16*)BCIEVENT->param) == NotifyFFF1)
									{
										if((BCIEVENT->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
											NotifyFFF1_Enable = TRUE;
										else
											NotifyFFF1_Enable = FALSE;										
									}
								}
								break;
						}											
					}
				}
				BLEOperate.F.B.EventValid = FALSE;
			}
			
			
			if(BLE_ConnectState)
			{
				if(!BLE_ConnectDisplay)		/* first time connect */
				{
					LCM_ConstString8(YesString,1,12,DSP_NORMAL);
/*					LED_FlashEnable(LED4,250);*/
#if	(_CHG_CONNECT_INTV_ == 1)
					BLE_CmdIndex = &BLE_SetConnectIntv;
					BLE_SendCmdIdx = TRUE;
#else
					BLE_ReadCnntIntv = TRUE;
#endif					
					BLE_ConnectDisplay = TRUE;
				}
				
				if(BLE_ReadCnntIntv)
				{
					BLE_ReadCnntIntv = FALSE;
					BLE_CmdOpcode = BCI_CONN_INTV1;
					BLE_CmdFlag = 0x00;
					BLE_SendCmdOpcode = TRUE;
				}
				
				if(ButtonChange)
				{
					ButtonChange = FALSE;
					x = BTN_GetStatus();
					x ^= key_status;
					if(x)
					{
						key_status = BTN_GetStatus();
						Dmessage.type = 0xB1;
						Dmessage.key  = (x & 0x0F) << 4;
						Dmessage.key |= key_status & 0x0F;
						Dmessage.serial ++;
						Dmessage.checksum =  Dmessage.type ^ Dmessage.key ^ Dmessage.serial;
						if(NotifyFFF1_Enable && !BLE_SendMessage)
						{
							BC7701_SendBCIPackage(NotifyFFF1,BCI_ServiceProperties,sizeof(KEY_MESSAGE),(u8 *)&Dmessage);	
							BLE_SendMessage = TRUE;
						}
					}
				}				
			}
			else
			{
				if(BLE_ConnectDisplay)		/*check Is connect? */
				{
					LCM_ConstString8(NoString,1,12,DSP_NORMAL);
					LCM_LineClear(7);
					LED_AlwaysOff(LED4);
					BLE_ConnectDisplay = FALSE;
				}
			}
			
			/* LED status update */
			if(LEDStatusUpdate)
			{
         	if(Hmessage.key & 0x01)
            {
            	LED_AlwaysOn(LED1);
            	LCM_ConstString8(DnString,2,12,DSP_NORMAL);
            }
            else
            {
            	LED_AlwaysOff(LED1);
            	LCM_ConstString8(UpString,2,12,DSP_NORMAL);
            }
            			
            if(Hmessage.key & 0x02)
            {
            	LED_AlwaysOn(LED2);
            	LCM_ConstString8(DnString,3,12,DSP_NORMAL);
            }
            else
            {
            	LED_AlwaysOff(LED2);
            	LCM_ConstString8(UpString,3,12,DSP_NORMAL);
            }
            			
            if(Hmessage.key & 0x04)
            {
            	LED_AlwaysOn(LED3);
            	LCM_ConstString8(DnString,4,12,DSP_NORMAL);
            }
            else
            {
            	LED_AlwaysOff(LED3);
            	LCM_ConstString8(UpString,4,12,DSP_NORMAL);
            }
            LEDStatusUpdate = FALSE;				
			}					
			
						
			if((BLE_SendFlag.value != 0) && !BLE_WaitEventRsp )
			{
				if(BLE_SleepMode)
				{
#if	(_MCU_SLEEP_ENABLE_ == 1)					
					SystemSleep = FALSE;
#endif					
					if(!BLE_WakeUpDelay)
					{
						BC7701_DummyWakeup(DUMMY_WAKEUP_WIDTH);
						BLE_WakeUpDlyTm = 2;			//2*2ms = 4ms
						BLE_WakeUpDelay = TRUE;
					}
					else
					{
						if(BLE_WakeUpDlyTm == 0)
						{
							//read BLE operate mode and check BLE wake up finish
							BC7701_TransmitCmdPackage(BCI_TEST_CTRL,0x00);
							BLE_WaitEventRsp = TRUE;
							BLE_WakeUpDelay = FALSE;
#if	(_MCU_SLEEP_ENABLE_ == 1)
							if(BLE_WakeUpSignal)
							{
								BLE_WakeUpSignal = FALSE;
								BLE_SleepDlyTm = _SLEEP_DELAY_TIMER_;
							}
#endif																			
						}
					}
				}
				else
				{					
					if(BLE_SendCmdIdx)
					{
						BC7701_TransmitPackageConst((tBCI_PACKAGE *)BLE_CmdIndex);
						BLE_SendCmdIdx = FALSE;
					}
					else
					{ 
						if(BLE_SendCmdOpcode)
						{
							BC7701_TransmitCmdPackage(BLE_CmdOpcode,BLE_CmdFlag);
							BLE_SendCmdOpcode = FALSE;
						}
						else
						{
							BC7701_TransmitPackage(0);
							BLE_SendMessage = FALSE;							
						} 
					}
					BLE_WaitEventRsp = TRUE;					
				}					
			}
			
			//BLE to Deep Sleep Mode
			if(!BLE_SleepMode && (BLE_SendFlag.value == 0) && !BLE_WaitEventRsp && (BTN_GetStatus() == 00) )
			{
				if(BLE_SleepDlyTm == 00)
				{
#if	(_MCU_SLEEP_ENABLE_ == 0)
					BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BC7701_OperateSleep);
#else
					BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BC7701_OperateSleep_WKUP);
#endif					
					BLE_WaitEventRsp = TRUE;
				}
			}
			else BLE_SleepDlyTm = _SLEEP_DELAY_TIMER_;
		}	
		
		if(BLEOperate.State == _BLE_PWR_ON_ERROR_)
		{
			if(BLE_PwronState == FALSE)
			{
				LCM_ConstString8(FailString,0,12,DSP_NORMAL);
				LED_AlwaysOn(LED4);
				BLE_PwronState = TRUE;
			}
		}	
	}
	_emi = FALSE;
	LED_AlwaysOff(LEDP);
#if	(_MCU_SLEEP_ENABLE_ == 1)
	BC7701_UARTWakeUpCtrl(ENABLE);
#endif	
   _wdtc = 0xAF;
   _pd2 = 1;
	_emi = TRUE;
SYSTEM_HALT:	
	GCC_HALT();
WakeUpBegin:
	_pd2 = 0;    
   GCC_CLRWDT();
   SystemSleep = FALSE;
	LED_AlwaysOn(LEDP);
#if	(_MCU_SLEEP_ENABLE_ == 1)
	BC7701_UARTWakeUpCtrl(DISABLE);
	BLE_WakeUpSignal = TRUE;
#endif		
   _emi = TRUE;
   _wdtc = 0x57;      
   goto  MainLoop;
}
/*---------------------------------------------------------------------------*/
